#include <Adafruit_GFX.h>
#include <Adafruit_NeoMatrix.h>
#include <Adafruit_NeoPixel.h>
#include "PCBWay_Logo.h"

#ifndef PSTR
 #define PSTR // Make Arduino Due happy
#endif

#define SPI_PIN 3
#define MATRIX_WIDTH 16
#define MATRIX_HEIGHT 16
#define MATRIX_VERT 3
#define MATRIX_HORIZ 2
#define BRIGHTNESS 32 // 1/8th

Adafruit_NeoMatrix matrix = Adafruit_NeoMatrix(MATRIX_WIDTH, MATRIX_HEIGHT, MATRIX_HORIZ, MATRIX_VERT, SPI_PIN,
  NEO_MATRIX_TOP     + NEO_MATRIX_LEFT +
  NEO_MATRIX_COLUMNS + NEO_MATRIX_ZIGZAG,
  NEO_GRB            + NEO_KHZ800);

void setup() {  
  matrix.begin();
  matrix.setBrightness(BRIGHTNESS);
}

int x    = 32;

void loop() {
  matrix.fillScreen(0);
  matrix.drawRGBBitmap(x, 1, PCBWay_Logo, 164, 46);
  x -= 1;
  if(x < -164) { x = 32; }
  matrix.show();
  //delay();
}
